/*
 * Decompiled with CFR 0.152.
 */
package com.yakumosakura.yakumoblade.entity;

import com.yakumosakura.yakumoblade.registry.slashblade.YAEntitiesRegistry;
import mods.flammpfeil.slashblade.entity.EntityAbstractSummonedSword;
import mods.flammpfeil.slashblade.entity.Projectile;
import mods.flammpfeil.slashblade.util.KnockBacks;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PlayMessages;
import org.joml.Vector3f;

public class SoulEdgeEntity
extends EntityAbstractSummonedSword {
    private static final EntityDataAccessor<Boolean> IT_FIRED = SynchedEntityData.m_135353_(SoulEdgeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> SPEED = SynchedEntityData.m_135353_(SoulEdgeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Vector3f> OFFSET = SynchedEntityData.m_135353_(SoulEdgeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_268676_);

    public SoulEdgeEntity(EntityType<? extends Projectile> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
        this.setPierce((byte)5);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IT_FIRED, (Object)false);
        this.f_19804_.m_135372_(SPEED, (Object)Float.valueOf(3.0f));
        this.f_19804_.m_135372_(OFFSET, (Object)Vec3.f_82478_.m_252839_());
    }

    public void doFire() {
        this.m_20088_().m_135381_(IT_FIRED, (Object)true);
    }

    public boolean itFired() {
        return (Boolean)this.m_20088_().m_135370_(IT_FIRED);
    }

    public void setSpeed(float speed) {
        this.m_20088_().m_135381_(SPEED, (Object)Float.valueOf(speed));
    }

    public float getSpeed() {
        return ((Float)this.m_20088_().m_135370_(SPEED)).floatValue();
    }

    public void setOffset(Vec3 offset) {
        this.m_20088_().m_135381_(OFFSET, (Object)offset.m_252839_());
    }

    public Vec3 getOffset() {
        return new Vec3((Vector3f)this.m_20088_().m_135370_(OFFSET));
    }

    public static SoulEdgeEntity createInstance(PlayMessages.SpawnEntity packet, Level worldIn) {
        return new SoulEdgeEntity(YAEntitiesRegistry.soul_edge, worldIn);
    }

    public void m_8119_() {
        if (!this.itFired() && this.m_9236_().m_5776_() && this.m_20202_() == null) {
            this.m_7998_(this.m_19749_(), true);
        }
        super.m_8119_();
    }

    public void m_6083_() {
        if (this.itFired()) {
            this.faceEntityStandby();
            Entity target = this.m_20202_();
            this.m_8127_();
            this.f_19797_ = 0;
            Vec3 dir = this.m_20252_(1.0f);
            if (target != null) {
                dir = this.m_20182_().m_82546_(target.m_20182_()).m_82542_(1.0, 0.0, 1.0).m_82541_();
            }
            this.m_6686_(dir.f_82479_, dir.f_82480_, dir.f_82481_, this.getSpeed(), 1.0f);
            if (target instanceof ServerPlayer) {
                ((ServerPlayer)target).m_6330_(SoundEvents.f_11893_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            return;
        }
        this.m_20256_(Vec3.f_82478_);
        if (this.canUpdate()) {
            this.m_6075_();
        }
        this.faceEntityStandby();
        if (this.f_19797_ >= this.getDelay()) {
            this.doFire();
        }
    }

    private void faceEntityStandby() {
        if (this.m_20202_() == null) {
            this.doFire();
            return;
        }
        int countPerRound = 24;
        double degPerRound = 360.0 / (double)countPerRound;
        double degYaw = (double)this.getDelay() * degPerRound - (double)((int)((double)this.getDelay() * degPerRound / 360.0)) * 360.0;
        double yaw = Math.toRadians(degYaw - 180.0);
        Vec3 dir = this.getOffset();
        dir = dir.m_82524_((float)(-yaw));
        dir = dir.m_82541_().m_82490_(2.0);
        dir = dir.m_82549_(this.m_20202_().m_20182_());
        this.f_19860_ = this.m_146909_();
        this.f_19859_ = this.m_146908_();
        this.m_146884_(dir);
        this.m_19915_((float)(-degYaw), 0.0f);
    }

    protected void m_5790_(EntityHitResult result) {
        Entity targetEntity = result.m_82443_();
        if (targetEntity instanceof LivingEntity) {
            KnockBacks.cancel.action.accept((LivingEntity)targetEntity);
        }
        super.m_5790_(result);
    }
}

